/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */
var timeoutglobalvar;var tinymce_editor_configs={};var select2_configs={};function setdisplay(e,t){var n=e;if(n.style.display!=t){n.style.display=t}return true}function cleandisplay(e){var t=document.getElementById(e);if(t){setdisplay(t,"block")}}function cleanhide(e){var t=document.getElementById(e);if(t){setdisplay(t,"none")}}function fillidfield(e,t){window.opener.document.forms.helpdeskform.elements.items_id.value=t;window.opener.document.forms.helpdeskform.elements.itemtype.value=e;window.close()}function markCheckboxes(e){var t=document.getElementById(e).getElementsByTagName("input");for(var n=0;n<t.length;n++){var a=t[n];if(a&&a.type=="checkbox"){if(a.disabled===false){a.checked=true}}}return true}function unMarkCheckboxes(e){var t=document.getElementById(e).getElementsByTagName("input");for(var n=0;n<t.length;n++){var a=t[n];if(a&&a.type=="checkbox"){a.checked=false}}return true}function displayOtherSelectOptions(e,t){if(e.options[e.selectedIndex].value==t){document.getElementById(t).style.display="inline"}else{document.getElementById(t).style.display="none"}return true}function checkAsCheckboxes(e,t,n='input[type="checkbox"]'){e=typeof e==="string"?document.getElementById(e):e;$("#"+CSS.escape(t)+" "+n+":enabled").prop("checked",$(e).is(":checked"));return true}$.fn.shiftSelectable=function(){var e;var t=this;document.onkeydown=function(e){var t=e.keyCode;if(t==16){$("html").addClass("user-select-none");document.onkeyup=function(){$("html").removeClass("user-select-none")}}};$(t).parent().click(function(n){var a=$(this).children("input[type=checkbox]");if(!e){e=a;return}if(n.shiftKey){var i=t.index(a);var r=t.index(e);t.slice(Math.min(i,r),Math.max(i,r)).prop("checked",$(e).is(":checked")).trigger("change")}e=a})};function showHideDiv(e,t="",n="",a=""){var i=$("#"+e);if(t!==""){var r=n.match(/^fa-/);var o;var s;if(!r){s=$("img[name="+CSS.escape(t)+"]");if(i.is(":visible")){s.attr("src",n)}else{s.attr("src",a)}}else{o=$("#"+CSS.escape(t));if(i.is(":visible")){o.removeClass(a).addClass(n)}else{o.removeClass(n).addClass(a)}}}if(i.is(":visible")){i.hide()}else{i.show()}}function toogle(e,t,n,a){if(document.getElementById){if(document.getElementById(e).value=="0"){document.getElementById(e).value="1";if(t!==""){document[t].src=n}}else{document.getElementById(e).value="0";if(t!==""){document[t].src=a}}}}function toggleTableDisplay(e,t,n,a){var i=document.getElementById(e).rows;for(var r=0;r<i.length;r++){if(i[r].className.indexOf("headerRow")==-1){if(i[r].style.display=="none"){i[r].style.display="table-row";if(t!==""){document[t].src=a}}else{i[r].style.display="none";if(t!==""){document[t].src=n}}}}if(document.getElementById(e+"2")){toggleTableDisplay(e+"2","")}if(document.getElementById(e+"3")){toggleTableDisplay(e+"3","")}if(document.getElementById(e+"4")){toggleTableDisplay(e+"4","")}if(document.getElementById(e+"5")){toggleTableDisplay(e+"5","")}}function submitGetLink(e,t){var n=document.createElement("form");n.method="post";n.action=e;for(var a in t){var i=document.createElement("input");i.setAttribute("name",a);i.setAttribute("value",t[a]);n.appendChild(i)}document.body.appendChild(n);n.submit();document.body.removeChild(n)}function selectAll(e){var t=$("#"+CSS.escape(e));var n=[];t.find("option").each(function(e,t){n[n.length]=$(t).attr("value")});t.val(n);t.trigger("change")}function deselectAll(e){$("#"+CSS.escape(e)).val("").trigger("change")}function massiveUpdateCheckbox(e,t){var n=null;if(typeof t=="boolean"){n=t}else if(typeof t=="string"){n=$("#"+CSS.escape(t)).prop("checked")}else if(typeof t=="object"){n=$(t).prop("checked")}if(typeof n=="undefined"){return false}$(e).each(function(){if(typeof t=="undefined"){n=!$(this).prop("checked")}$(this).prop("checked",n)});return true}var filter_timeline=function(){$(document).on("click",".filter_timeline li a",function(e){e.preventDefault();var t=$(this);$(".h_item").addClass("h_hidden");if(t.data("type")=="reset"){$(".filter_timeline li a").removeClass("h_active");$(".h_item").removeClass("h_hidden");return}t.toggleClass("h_active");var n=[];$(".filter_timeline .h_active").each(function(){n.push(".h_content."+$(this).data("type"))});$(n.join(", ")).each(function(){$(this).parent().removeClass("h_hidden")});if(n.length===0){$(".h_item").removeClass("h_hidden")}})};var read_more=function(){$(document).on("click",".long_text .read_more a, .long_text .read_more .read_more_button",function(){$(this).parents(".long_text").removeClass("long_text");$(this).parent(".read_more").remove();return false})};if($(window).width()<=700){var didScroll;var lastScrollTop=0;var delta=5;var navbarHeight=$("header").outerHeight();$(window).scroll(function(){didScroll=true});setInterval(function(){if(didScroll){scollHeaderResponsive();didScroll=false}},250);var scollHeaderResponsive=function(){var e=$(this).scrollTop();if(Math.abs(lastScrollTop-e)<=delta){return}if(e>lastScrollTop&&e>navbarHeight){$("#header").removeClass("nav-down").addClass("nav-up")}else{if(e+$(window).height()<$(document).height()){$("#header").removeClass("nav-up").addClass("nav-down")}}lastScrollTop=e}}var switchFoldMenu=function(){$.ajax({url:CFG_GLPI.root_doc+"/ajax/switchfoldmenu.php",type:"POST",datatype:"json",success:function(e){if(e.success===true){$("body").toggleClass("navbar-collapsed");var t=$("body").hasClass("navbar-collapsed");$("#navbar-menu li.dropdown").toggleClass("dropend");$("#navbar-menu .dropdown-menu.animate__animated").toggleClass("animate__animated");if(t){$("#navbar-menu .dropdown-menu, #navbar-menu .nav-link").removeClass("show")}else{if($("#navbar-menu .nav-link.show").length==0){$("#navbar-menu .nav-link.active + .dropdown-menu").addClass("show")}}}}})};$(function(){$("body").delegate("td","mouseover mouseleave",function(e){var t=$(this).closest("tr").children().index($(this));var n=$(this).closest("tr");if(!$(this).closest("tr").hasClass("noHover")){if(e.type=="mouseover"){n.addClass("rowHover");if(n.has("td[rowspan]").length===0){n.prevAll("tr:has(td[rowspan]):first").find("td[rowspan]").addClass("rowHover")}$(this).closest("table").find("tr:not(.noHover) th:nth-child("+(t+1)+")").addClass("headHover")}else{n.removeClass("rowHover");n.removeClass("rowHover").prevAll("tr:has(td[rowspan]):first").find("td[rowspan]").removeClass("rowHover");$(this).closest("table").find("tr:not(.noHover) th:nth-child("+(t+1)+")").removeClass("headHover")}}});$(".reduce-menu").on("click",function(e){e.preventDefault();e.stopPropagation();switchFoldMenu()});$(document).on("keydown","#page form textarea",function(e){if(e.ctrlKey&&e.keyCode==13){submitparentForm($(this))}});$(document).on("click",".see_debug",function(){$("body > .debug-panel").toggle()})});var submitparentForm=function(e){var t=$(e).closest("form");var n=t.find("[type=submit]").filter("[name=add], [name=update]");if(n.length==1){return n.trigger("click")!==false}return false};var isImage=function(e){var t=["image/gif","image/jpeg","image/jpg","image/png"];if($.inArray(e.type,t)<0){return false}else{return true}};var getExtIcon=function(e){var t=CFG_GLPI.root_doc+"/pics/icones/"+e+"-dist.png";if(!urlExists(t)){t=CFG_GLPI.root_doc+"/pics/icones/defaut-dist.png"}return'<img src="'+_.escape(t)+'" title="'+_.escape(e)+'">'};var urlExists=function(e){var t=false;$.ajax({type:"HEAD",url:e,async:false,success:function(){t=true}});return t};var getSize=function(e){var t=[_x("size","B"),_x("size","KiB"),_x("size","MiB"),_x("size","GiB"),_x("size","TiB"),_x("size","PiB"),_x("size","EiB"),_x("size","ZiB"),_x("size","YiB")];var n="";t.some(function(t){if(e>1024){e=e/1024}else{n=t;return true}});return Math.round(e*100,2)/100+n};var getBijectiveIndex=function(e){var t="";while(parseInt(e)>0){e--;t=String.fromCharCode("A".charCodeAt(0)+e%26)+t;e/=26}return t};var stopEvent=function(e){e.preventDefault();e.stopPropagation()};function _eltRealSize(e){var t=0;t+=e.outerHeight();t+=parseFloat(e.css("margin-top").replace("px",""));t+=parseFloat(e.css("margin-bottom").replace("px",""));t+=parseFloat(e.css("padding-top").replace("px",""));t+=parseFloat(e.css("padding-bottom").replace("px",""));return t}var initMap=function(e,t,n,a={position:[0,0],zoom:1}){t=typeof t!=="undefined"?t:"map";n=typeof n!=="undefined"?n:"200px";if(n=="full"){var i=$(window).height();var r=$(e).offset()["top"]+$(e).outerHeight();var o=Math.floor(i-r-2);var s=300;if(o<s){o=s}n=o+"px"}e.append($('<div id="'+_.escape(t)+'" style="height: '+_.escape(n)+'"></div>'));var l=L.map(t,{fullscreenControl:true,minZoom:2}).setView(a.position,a.zoom);L.tileLayer("https://{s}.tile.osm.org/{z}/{x}/{y}.png",{attribution:"&copy; <a href='https://osm.org/copyright'>OpenStreetMap</a> contributors"}).addTo(l);return l};var showMapForLocation=function(e){var t=$(e).data("fid");var n=$("#"+CSS.escape(t)).val();if(n==0){return}glpi_html_dialog({title:__("Display on map"),body:"<div id='location_map_dialog'/>",dialogclass:"modal-xl",show:function(){var e=initMap($("#location_map_dialog"),"location_map","500px");e.spin(true);$.ajax({dataType:"json",method:"POST",url:CFG_GLPI.root_doc+"/ajax/getMapPoint.php",data:{itemtype:"Location",items_id:$("#"+CSS.escape(t)).val()}}).done(function(t){if(t.success===false){glpi_html_dialog({body:t.message})}else{var n=[];var a=L.marker([t.lat,t.lng]);n.push(a);var i=L.featureGroup(n).addTo(e);e.fitBounds(i.getBounds(),{padding:[50,50],maxZoom:10})}}).always(function(){e.spin(false)})}})};var query={};function markMatch(e,t){var n=e.toUpperCase().indexOf(t.toUpperCase());var a=$("<span></span>");if(n<0){a.append(_.escape(e));return a.html()}a.html(_.escape(e.substring(0,n)));var i=$("<span class='select2-rendered__match'></span>");i.html(_.escape(e.substring(n,n+t.length)));a.append(i);a.append(_.escape(e.substring(n+t.length)));return a.html()}var templateResult=function(e){var t=$("<span></span>");t.attr("title",e.title);if(typeof query.term!=="undefined"&&typeof e.rendered_text!=="undefined"){t.html(e.rendered_text)}else{if(!e.text){return null}var n=e.text;if(!e.id){t.html(_.escape(n));return t}var a=query.term||"";var i=markMatch(n,a);if(e.level){var r="";var o=e.level;while(o>1){r=r+"&nbsp;&nbsp;&nbsp;";o=o-1}t.html(r+"&raquo;"+i)}else{t.html(i)}}return t};var typewatch=function(){var e=0;return function(t,n){clearTimeout(e);e=setTimeout(t,n)}}();var templateSelection=function(e){var t="";if(!("element"in e)){t=e.text}else if(Object.prototype.hasOwnProperty.call(e,"selection_text")){t=e.selection_text}else if(e.element.parentElement.nodeName=="OPTGROUP"){t=e.element.parentElement.getAttribute("label")+" - "+e.text}else{t=e.text}var n=$("<span></span>");n.html(_.escape(t));return n};var templateItilStatus=function(e){if(e===false){return null}var t=e.id||0;var n="";switch(parseInt(t)){case 1:n="new ti ti-circle-filled";break;case 2:n="assigned ti ti-circle";break;case 3:n="planned ti ti-calendar";break;case 4:n="waiting ti ti-circle-filled";break;case 5:n="solved ti ti-circle";break;case 6:n="closed ti ti-circle-filled";break;case 7:n="accepted ti ti-circle-check-filled";break;case 8:n="observe ti ti-eye";break;case 9:n="eval ti ti-circle";break;case 10:n="approval ti ti-help-circle";break;case 11:n="test ti ti-help-circle";break;case 12:n="qualif ti ti-circle";break;case 13:n="refused ti ti-circle-x";break;case 14:n="canceled ti ti-ban";break}return $(`<span><i class="itilstatus ${n}"></i> ${_.escape(e.text)}</span>`)};var templateValidation=function(e){if(e===false){return null}var t=e.id||0;var n="";switch(parseInt(t)){case 2:n="waiting ti ti-clock";break;case 3:n="accepted ti ti-circle-check-filled";break;case 4:n="refused ti ti-circle-x";break}return $(`<span><i class="validationstatus ${n}"></i> ${_.escape(e.text)}</span>`)};var templateItilPriority=function(e){if(e===false){return null}var t=e.id||0;var n=CFG_GLPI["priority_"+t]||"";var a="";if(n.length>0){a+=`<i class='ti ti-circle-filled' style='color: ${_.escape(n)}'></i>`}return $(`<span>${a}&nbsp;${_.escape(e.text)}</span>`)};var getTextWithoutDiacriticalMarks=function(e){e=e.normalize("NFD");return e.replace(/[\u0300-\u036f]/g,"")};var escapeMarkupText=function(e){if(typeof e!=="string"){return e}return _.escape(e)};function updateProgress(e){var t=$("#"+CSS.escape(e)).first();$("div[data-progressid='"+CSS.escape(e)+"']").each(function(e,n){var a=$(n);var i=a.find(".progress-fg").first();var r=t.attr("value")/t.attr("max")*100;i.width(r+"%");if(a.data("append-percent")===1){var o=a.prop("title").replace(new RegExp("\\d*%$"),t.attr("value")+"%").trim();t.prop("title",o);a.prop("title",o)}})}function GoInFullscreen(e){if(e.requestFullscreen){e.requestFullscreen()}else if(e.mozRequestFullScreen){e.mozRequestFullScreen()}else if(e.webkitRequestFullscreen){e.webkitRequestFullscreen()}else if(e.msRequestFullscreen){e.msRequestFullscreen()}}function GoOutFullscreen(){if(document.exitFullscreen){document.exitFullscreen()}else if(document.mozCancelFullScreen){document.mozCancelFullScreen()}else if(document.webkitExitFullscreen){document.webkitExitFullscreen()}else if(document.msExitFullscreen){document.msExitFullscreen()}}function getUuidV4(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=Math.random()*16|0,n=e=="x"?t:t&3|8;return n.toString(16)})}function setHasUnsavedChanges(e){window.glpiUnsavedFormChanges=e;document.dispatchEvent(new CustomEvent("glpiFormChangeEvent",{has_unsaved_changes:e}))}function hasUnsavedChanges(){return window.glpiUnsavedFormChanges}setHasUnsavedChanges(false);$(document).ready(function(){$(document).on("input",'form[data-track-changes="true"] input:not([data-track-changes=""]),'+'form[data-track-changes="true"] textarea:not([data-track-changes="false"])',function(){setHasUnsavedChanges(true)});$(document).on("change",'form[data-track-changes="true"] select:not([data-track-changes=""])',function(){setHasUnsavedChanges(true)});$(window).on("beforeunload",function(e){if(hasUnsavedChanges()){e.preventDefault();return""}});$(document).on("submit","form",e=>{if(e.originalEvent&&$(e.originalEvent.submitter).attr("data-block-on-unsaved")==="true"){return}setHasUnsavedChanges(false)})});function onTinyMCEChange(e){var t=$(e.target)[0];if($(t.targetElm).data("trackChanges")!==false){if($(t.formElement).data("trackChanges")===true){setHasUnsavedChanges(true)}}}function relativeDate(e){var t=new Date,n=new Date(e);t.setHours(0,0,0,0);n.setHours(0,0,0,0);var a=(+new Date-Date.parse(e))/1e3,i=a/60,r=i/60,o=(t-n)/864e5,s=o/7,l=o/30.44,c=o/365.24,d;return(d=Math.round(a))===1?__("just now"):i<1.01?__("%s seconds ago").replace("%s",d):(d=Math.round(i))===1?__("a minute ago"):r<1.01?__("%s minutes ago").replace("%s",d):(d=Math.round(r))===1?__("an hour ago"):o<1.01?__("%s hours ago").replace("%s",d):(d=Math.round(o))===1?__("yesterday"):s<1.01?__("%s days ago").replace("%s",d):(d=Math.floor(s))===1?__("a week ago"):l<1.01?__("%s weeks ago").replace("%s",d):(d=Math.floor(l))===1?__("a month ago"):c<1?__("%s months ago").replace("%s",d):(d=Math.floor(c))===1?__("a year ago"):__("%s years ago").replace("%s",d)}function getFlatPickerLocale(e,t){if(e=="en"&&t=="GB"){return{firstDayOfWeek:1}}else{return e}}function updateItemOnEvent(e,t,n,a={},i=["change"],r=-1,o=-1,s=[]){if(!Array.isArray(e)){e=[e]}const l=e;$(l).each((o,l)=>{$(i).each((i,o)=>{const c=l.replaceAll("[","_").replaceAll("]","_");const d=$(`#${CSS.escape(c)}`);d.on(o,()=>{const i=r>=0||s.length>0;const o=r>=0&&d.val().length()>=r;const l=s.length>0&&s.includes(d.val());const c=()=>{const i={};$.each(a,(t,n)=>{if(typeof n==="string"){const a=n.match(/^__VALUE(\d+)__$/);if(a!==null){i[t]=$("#"+CSS.escape(e[a[0]])).val()}else if(n==="__VALUE__"){i[t]=$("#"+CSS.escape(e[0])).val()}else{i[t]=n}}else{i[t]=n}});$(t).load(n,i)};if(i&&(o||l)){c()}else if(!i){c()}})})})}function updateItemOnSelectEvent(e,t,n,a={}){updateItemOnEvent(e,t,n,a,["change"],-1,-1,[])}function initTooltips(e){if(e===undefined){e=document}const t=e.querySelectorAll('[data-bs-toggle="tooltip"]:not([data-bs-original-title])');t.forEach(function(e){const t={delay:{show:50,hide:50},html:e.hasAttribute("data-bs-html")?e.getAttribute("data-bs-html")==="true":false,placement:e.hasAttribute("data-bs-placement")?e.getAttribute("data-bs-placement"):"auto",trigger:e.hasAttribute("data-bs-trigger")?e.getAttribute("data-bs-trigger"):"hover"};return new bootstrap.Tooltip(e,t)});const n=e.querySelectorAll('[data-bs-toggle="popover"]:not([data-bs-original-title])');n.forEach(function(e){const t={delay:{show:50,hide:50},html:e.hasAttribute("data-bs-html")?e.getAttribute("data-bs-html")==="true":false,placement:e.hasAttribute("data-bs-placement")?e.getAttribute("data-bs-placement"):"auto",trigger:e.hasAttribute("data-bs-trigger")?e.getAttribute("data-bs-trigger"):"hover",sanitize:e.hasAttribute("data-bs-sanitize")?e.getAttribute("data-bs-sanitize")==="true":true};return new bootstrap.Popover(e,t)})}$(document).ajaxSend(function(e,t,n){if(n.type!=="POST"){return}t.setRequestHeader("X-Glpi-Csrf-Token",getAjaxCsrfToken())});function getAjaxCsrfToken(){const e=document.querySelector('meta[property="glpi:csrf_token"]');return e!==null?e.getAttribute("content"):null}$(function(){$(document).ajaxComplete(function(){initTooltips()});setTimeout(function(){initTooltips()},50)});jQuery.expr.filters.icontains=function(e,t,n){return(e.innerText||e.textContent||"").toLowerCase().indexOf(n[3].toLowerCase())>-1};function tableToDetails(e){let t=false;const n=$(e).find(".section-header, .section-content");let a="";n.each((e,n)=>{if(n.classList.contains("section-header")){if(t){a+="</pre></details>"}a+=`<details><summary>${_.escape(n.innerText)}</summary><pre>`;t=true}else{if(t){a+=_.escape(n.innerText)}}});if(t){a+="</pre></details>"}return a}function flashIconButton(e,t,n,a){const i=$(e);const r=i.find("i").eq(0);const o=i.attr("class");const s=r.attr("class");i.removeClass();r.removeClass();i.addClass(t);r.addClass(n);window.setTimeout(()=>{i.removeClass();r.removeClass();i.addClass(o);r.addClass(s)},a)}function uniqid(e="",t=false){const n=crypto.getRandomValues(new Uint32Array(10)).reduce((e,t)=>e*t,1);const a=n.toString(16).slice(0,14).padEnd(14,"0");const i=t?"."+Math.floor(Math.random()*1e8).toString().padStart(8,"0"):"";return`${e}${a}${i}`}function blockFormSubmit(e,t){var n=null;if(t.originalEvent&&t.originalEvent.submitter){n=$(t.originalEvent.submitter)}if(n===null||!n.is("button")){n=e.find('button[name="add"]:first, button[name="update"]:first');if(n.length===0){n=e.find('button[type="submit"]:first')}}if(n.length>0&&n.is("button")){n.html(`<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>`)}e.find('button[type="submit"]').click(e=>{e.preventDefault()});e.attr("data-submitted","true")}window.validateFormWithBootstrap=function(e){const t=$(e.target).closest("form");const n=t[0].checkValidity();if(t.hasClass("needs-validation")){if(!n){e.preventDefault();e.stopPropagation()}t.addClass("was-validated")}return n};$(()=>{$(document.body).on("submit","form[data-submit-once]",e=>{const t=$(e.target).closest("form");if(t.attr("data-submitted")==="true"){e.preventDefault();return false}else{let n=null;if(e.originalEvent&&e.originalEvent.submitter){n=$(e.originalEvent.submitter)}if((n===null||n.attr("formnovalidate")===undefined)&&!window.validateFormWithBootstrap(e)){return false}if(n!==null&&n.is("button")&&n.attr("data-block-on-unsaved")==="true"&&hasUnsavedChanges()){const e=function(e){e.preventDefault()};n.on("click",e);n.data("original_html",n.html());n.html(`<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>`);window.setTimeout(()=>{n.off("click",e);n.html(n.data("original_html"))},100);return}blockFormSubmit(t,e)}});$(document).on("click focus","body",function(e){if($(e.target).closest(".simulate-focus").length==0&&$(e.target).closest(".tox-toolbar__overflow").length==0&&$(e.target).closest(".tox-tinymce-aux").length==0){$(".content-editable-tinymce").removeClass("simulate-focus")}});$(document).on("click","[data-glpi-clipboard-text]",function(){const e=$(this).data("glpi-clipboard-text");if(navigator.clipboard===undefined){glpi_toast_error(__("Unable to copy to clipboard (insecure context)."))}else{navigator.clipboard.writeText(e);glpi_toast_info(__("Copied to clipboard"))}})});function strip_tags(e){var t=(new DOMParser).parseFromString(e,"text/html");return t.body.textContent}$(document.body).on("shown.bs.tab",'a[data-bs-toggle="tab"]',e=>{const t=$(e.target);const n=t.parent().index()===0;const a=t.closest(".card-tabs").parent().find(".navigationheader");if(a.length>0){const e=a.find("span.is_recursive-toggle");if(e.length>0){const t=e.find("input");const a=t.prop("disabled");if(t.attr("data-disabled-initial")===undefined){t.attr("data-disabled-initial",a||false)}const i=t.attr("data-disabled-initial")==="true";t.prop("disabled",n?i:true)}}});function showDisclosablePasswordField(e){$("#"+CSS.escape(e)).prop("type","text")}function hideDisclosablePasswordField(e){$("#"+CSS.escape(e)).prop("type","password")}function copyDisclosablePasswordFieldToClipboard(e){const t=$("#"+CSS.escape(e)).prop("type")==="password";if(t){showDisclosablePasswordField(e)}$("#"+CSS.escape(e)).select();try{document.execCommand("copy")}catch{alert("Copy to clipboard failed'")}if(t){hideDisclosablePasswordField(e)}}function initSortableTable(e){const t=$(`#${CSS.escape(e)}`);const n=e=>{const n=t.data("sort");t.data("sort",e);const a=t.data("order");const i=n===e&&a==="up"?"down":"up";t.data("order",i);const r=t.find("thead").first();const o=r.find("th").eq(e);r.find('th i[class*="ti ti-caret"]').removeClass("ti-caret-down-filled ti-caret-up-filled");const s=o.find("i");if(s.length===0){o.eq(0).append(`<i class="ti ti-caret-${i}-filled"></i>`)}else{s.addClass(i==="up"?"ti-caret-up-filled":"ti-caret-down-filled")}const l=t.find("tbody tr");const c=l.sort((t,n)=>{const a=$(t).find("td").eq(e);const r=$(n).find("td").eq(e);let o=a.text();let s=r.text();if(a.attr("data-value-unit")!==undefined){o=o.replace(a.attr("data-value-unit"),"").trim()}if(r.attr("data-value-unit")!==undefined){s=s.replace(r.attr("data-value-unit"),"").trim()}if(!isNaN(o)&&!isNaN(s)){o=Number(o);s=Number(s)}if(o===s){return 0}if(i==="up"){return o<s?-1:1}return o>s?-1:1});t.find("tbody").html(c)};t.find("thead th").attr("role","button");t.find("thead th").addClass("fw-bold");t.find("thead th").each((e,t)=>{$(t).on("click",()=>{n(e)})})}function waitForElement(e){return new Promise(t=>{if(document.querySelector(e)){return t(document.querySelector(e))}const n=new MutationObserver(()=>{if(document.querySelector(e)){t(document.querySelector(e));n.disconnect()}});n.observe(document.body,{childList:true,subtree:true})})}function getUUID(){if(typeof crypto==="undefined"||typeof crypto.randomUUID==="undefined"){return uniqid()}return crypto.randomUUID()}if(typeof GlpiCommonAjaxController=="function"){new GlpiCommonAjaxController}function setupAjaxDropdown(config){const field_id=CSS.escape(config.field_id);const select2_el=$("#"+field_id).select2({containerCssClass:config.container_css_class,width:config.width,multiple:config.multiple,placeholder:config.placeholder,allowClear:config.allowclear,minimumInputLength:0,quietMillis:100,dropdownAutoWidth:true,dropdownParent:$("#"+field_id).closest("div.modal, div.offcanvas, div.dropdown-menu, body"),minimumResultsForSearch:config.ajax_limit_count,ajax:{url:config.url,dataType:"json",type:"POST",data:function(e){query=e;var t=$.extend({},config.params,{searchText:e.term});if(config.parent_id_field!==""){t.parent_id=document.getElementById(config.parent_id_field).value}t.page_limit=config.dropdown_max;t.page=e.page||1;Object.keys(t).forEach(function(e){if(t[e]===false){t[e]=0}else if(t[e]===true){t[e]=1}});return t},processResults:function(e,t){t.page=t.page||1;var n=e.count>=config.dropdown_max;return{results:e.results,pagination:{more:n}}}},templateResult:config.templateResult,templateSelection:config.templateSelection}).bind("setValue",function(e,t){$.ajax(config.url,{data:$.extend({},config.params,{_one_id:t}),dataType:"json",type:"POST"}).done(function(e){var n=function(e,t){var a=false;$.each(e,function(e,i){if(Object.prototype.hasOwnProperty.call(i,"id")&&i.id==t){a=i;return false}if(Object.prototype.hasOwnProperty.call(i,"children")){a=n(i.children,t)}});return a};var a=n(e.results,t);if(a!==false){var i=new Option(a.text,a.id,true,true);$("#"+field_id).append(i).trigger("change")}})});if(config.on_change!==""){$("#"+field_id).on("change",function(){eval(config.on_change)})}$("label[for="+field_id+"]").on("click",function(){$("#"+field_id).select2("open")});$("#"+field_id).on("select2:open",function(e){const t=document.querySelector(`.select2-search__field[aria-controls='select2-${CSS.escape(e.target.id)}-results']`);if(t){t.focus()}});return select2_el}function setupAdaptDropdown(e){const t=CSS.escape(e.field_id);const n={width:e.width,dropdownAutoWidth:true,dropdownCssClass:e.dropdown_css_class,dropdownParent:$("#"+t).closest("div.modal, div.offcanvas, div.dropdown-menu, body"),quietMillis:100,minimumResultsForSearch:e.ajax_limit_count,matcher:function(e,t){query=e;if($.trim(e.term)===""){return t}const n="#-#-#-#-#";const a="#+#+#+#+#";const i=function(e){return _.escape(e).replaceAll(n,'<span class="select2-rendered__match">').replaceAll(a,"</span>")};var r=getTextWithoutDiacriticalMarks(e.term);var o=typeof t.text==="string"?getTextWithoutDiacriticalMarks(t.text):"";var s={pre:n,post:a};if(typeof t.children==="undefined"){var l=fuzzy.match(r,o,s);if(l==null){return false}t.rendered_text=i(l.rendered);t.score=l.score;return t}var c=[];$.each(t.children,function(e,n){var a=typeof n.text==="string"?getTextWithoutDiacriticalMarks(n.text):"";var l=fuzzy.match(r,a,s);var d=fuzzy.match(r,o,s);if(l!==null||d!==null){if(d!==null){t.score=d.score;t.rendered_text=i(d.rendered)}if(l!==null){n.score=l.score;n.rendered_text=i(l.rendered)}c.push(n)}});if(c.length){var d=$.extend({},t,true);d.children=c;return d}return null},templateResult:e.templateresult,templateSelection:e.templateselection};if(e.placeholder!==undefined&&e.placeholder!==""){n.placeholder=e.placeholder}const a=$("#"+t).select2(n);a.bind("setValue",(e,...n)=>{$("#"+t).val(n).trigger("change")});$("label[for="+t+"]").on("click",function(){$("#"+t).select2("open")});$("#"+t).on("select2:open",function(e){const t=document.querySelector(`.select2-search__field[aria-controls='select2-${CSS.escape(e.target.id)}-results']`);if(t){t.focus()}});return a}window.displaySessionMessages=()=>{$.ajax({method:"GET",url:CFG_GLPI.root_doc+"/ajax/displayMessageAfterRedirect.php",data:{get_raw:true}}).then(e=>{$.each(e,(e,t)=>{$.each(t,(t,n)=>{switch(parseInt(e)){case 1:glpi_toast_error(n);break;case 2:glpi_toast_warning(n);break;default:glpi_toast_info(n)}})})})};document.addEventListener("shown.bs.modal",e=>{const t=e.target.closest(".modal");if(t){t.setAttribute("data-cy-shown","true")}});document.addEventListener("hidden.bs.modal",e=>{const t=e.target.closest(".modal");if(t){t.setAttribute("data-cy-shown","false")}});$(document).on("click","div[data-glpi-tinymce-init-on-demand-render]",function(){const e=$(this);const t=e.attr("data-glpi-tinymce-init-on-demand-render");e.removeAttr("data-glpi-tinymce-init-on-demand-render");const n=$("#"+t);const a=$(`\n        <div class="glpi-form-editor-loading-overlay position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-white bg-opacity-75">\n            <div class="spinner-border spinner-border-sm text-secondary" role="status">\n                <span class="visually-hidden">${__("Loading...")}</span>\n            </div>\n        </div>\n    `);n.show();e.css("position","relative").append(a);tinyMCE.init(tinymce_editor_configs[t]).then(t=>{t[0].focus();e.remove()})});document.addEventListener("focusin",e=>{if(e.target.closest(".tox-tinymce, .tox-tinymce-aux, .moxman-window, .tam-assetmanager-root")!==null){e.stopImmediatePropagation()}});